/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Comparator;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.rocksdb.RocksIterator;

class RocksDBRangeIterator
extends RocksDbIterator {
    private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;
    private final byte[] rawLastKey;
    private final boolean forward;
    private final boolean toInclusive;

    RocksDBRangeIterator(String storeName, RocksIterator iter, Set<KeyValueIterator<Bytes, byte[]>> openIterators, Bytes from, Bytes to, boolean forward, boolean toInclusive) {
        super(storeName, iter, openIterators, forward);
        this.forward = forward;
        this.toInclusive = toInclusive;
        if (forward) {
            iter.seek(from.get());
            this.rawLastKey = to.get();
            if (this.rawLastKey == null) {
                throw new NullPointerException("RocksDBRangeIterator: RawLastKey is null for key " + to);
            }
        } else {
            iter.seekForPrev(to.get());
            this.rawLastKey = from.get();
            if (this.rawLastKey == null) {
                throw new NullPointerException("RocksDBRangeIterator: RawLastKey is null for key " + from);
            }
        }
    }

    @Override
    public KeyValue<Bytes, byte[]> makeNext() {
        Object next = super.makeNext();
        if (next == null) {
            return (KeyValue)this.allDone();
        }
        if (this.forward) {
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) < 0) {
                return next;
            }
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) == 0) {
                return this.toInclusive ? next : (KeyValue)this.allDone();
            }
            return (KeyValue)this.allDone();
        }
        if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawLastKey) >= 0) {
            return next;
        }
        return (KeyValue)this.allDone();
    }
}

