/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import org.apache.kafka.connect.mirror.DefaultReplicationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityReplicationPolicy
extends DefaultReplicationPolicy {
    private static final Logger log = LoggerFactory.getLogger(IdentityReplicationPolicy.class);
    public static final String SOURCE_CLUSTER_ALIAS_CONFIG = "source.cluster.alias";
    private String sourceClusterAlias = null;

    @Override
    public void configure(Map<String, ?> props) {
        super.configure(props);
        if (props.containsKey(SOURCE_CLUSTER_ALIAS_CONFIG)) {
            this.sourceClusterAlias = (String)props.get(SOURCE_CLUSTER_ALIAS_CONFIG);
            log.info("Using source cluster alias `{}`.", (Object)this.sourceClusterAlias);
        }
    }

    @Override
    public String formatRemoteTopic(String sourceClusterAlias, String topic) {
        if (this.looksLikeHeartbeat(topic)) {
            return super.formatRemoteTopic(sourceClusterAlias, topic);
        }
        return topic;
    }

    @Override
    public String topicSource(String topic) {
        if (this.looksLikeHeartbeat(topic)) {
            return super.topicSource(topic);
        }
        return this.sourceClusterAlias;
    }

    @Override
    public String upstreamTopic(String topic) {
        if (this.looksLikeHeartbeat(topic)) {
            return super.upstreamTopic(topic);
        }
        return topic;
    }

    private boolean looksLikeHeartbeat(String topic) {
        return topic != null && topic.endsWith("heartbeats");
    }
}

