/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroDatumWriter;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigAvroOutputFormat
extends FileOutputFormat<NullWritable, Object> {
    public static final String EXT = ".avro";
    public static final String DEFLATE_LEVEL_KEY = "avro.mapred.deflate.level";
    public static final int DEFAULT_DEFLATE_LEVEL = 1;
    private Schema schema = null;

    public PigAvroOutputFormat() {
    }

    public PigAvroOutputFormat(Schema s) {
        this.schema = s;
    }

    public static void setDeflateLevel(Job job, int level) {
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        job.getConfiguration().setInt(DEFLATE_LEVEL_KEY, level);
    }

    public RecordWriter<NullWritable, Object> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.schema == null) {
            throw new IOException("expect a not-null schema.");
        }
        Configuration conf = context.getConfiguration();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new PigAvroDatumWriter(this.schema));
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            int level = context.getConfiguration().getInt(DEFLATE_LEVEL_KEY, 1);
            writer.setCodec(CodecFactory.deflateCodec((int)level));
        }
        Path path = this.getDefaultWorkFile(context, EXT);
        writer.create(this.schema, (OutputStream)path.getFileSystem(conf).create(path));
        return new PigAvroRecordWriter((DataFileWriter<Object>)writer);
    }
}

