/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.avro.ASCommons;
import org.apache.pig.piggybank.storage.avro.ASLog;
import org.apache.pig.piggybank.storage.avro.AvroSchema2Pig;
import org.apache.pig.piggybank.storage.avro.AvroSchemaManager;
import org.apache.pig.piggybank.storage.avro.PigAvroInputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroOutputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordReader;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordWriter;
import org.apache.pig.piggybank.storage.avro.PigSchema2Avro;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadMetadata {
    private static final String NOTNULL = "NOTNULL";
    private static final String AVRO_OUTPUT_SCHEMA_PROPERTY = "avro_output_schema";
    private static final String SCHEMA_DELIM = "#";
    private static final String SCHEMA_KEYVALUE_DELIM = "@";
    private int storeFuncIndex = 0;
    private PigAvroRecordWriter writer = null;
    private Schema outputAvroSchema = null;
    private boolean nullable = true;
    private PigAvroRecordReader reader = null;
    private Schema inputAvroSchema = null;
    private boolean checkSchema = true;

    public void setLocation(String location, Job job) throws IOException {
        ASCommons.addInputPaths(location, job);
        if (this.inputAvroSchema == null) {
            this.inputAvroSchema = this.getAvroSchema(location, job);
        }
    }

    protected Schema getAvroSchema(String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path(location);
        return this.getAvroSchema(path, fs);
    }

    protected Schema getAvroSchema(Path path, FileSystem fs) throws IOException {
        if (!fs.isDirectory(path)) {
            return this.getSchema(path, fs);
        }
        FileStatus[] ss = fs.listStatus(path, ASCommons.PATH_FILTER);
        Schema schema = null;
        if (ss.length > 0) {
            if (ASCommons.noDir(ss)) {
                return this.getSchema(path, fs);
            }
            for (FileStatus s : ss) {
                Schema newSchema = this.getAvroSchema(s.getPath(), fs);
                if (schema == null) {
                    schema = newSchema;
                    if (this.checkSchema) continue;
                    System.out.println("Do not check shema; use schema of " + s.getPath());
                    return schema;
                }
                if (schema.equals((Object)newSchema)) continue;
                throw new IOException("Input path is " + path + ". Sub-direcotry " + s.getPath() + " contains different schema " + newSchema + " than " + schema);
            }
        }
        if (schema == null) {
            throw new IOException("Cannot get avro schema! Input path " + path + " might be empty.");
        }
        return schema;
    }

    protected Schema getSchema(Path path, FileSystem fs) throws IOException {
        Path lastFile = ASCommons.getLast(path, fs);
        GenericDatumReader avroReader = new GenericDatumReader();
        FSDataInputStream hdfsInputStream = fs.open(lastFile);
        DataFileStream avroDataStream = new DataFileStream((InputStream)hdfsInputStream, (DatumReader)avroReader);
        Schema ret = avroDataStream.getSchema();
        avroDataStream.close();
        return ret;
    }

    public InputFormat getInputFormat() throws IOException {
        ASLog.funcCall("getInputFormat");
        return new PigAvroInputFormat(this.inputAvroSchema);
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        ASLog.funcCall("prepareToRead");
        this.reader = (PigAvroRecordReader)reader;
    }

    public Tuple getNext() throws IOException {
        try {
            boolean notDone = this.reader.nextKeyValue();
            if (!notDone) {
                return null;
            }
            return (Tuple)this.reader.getCurrentValue();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        ASLog.funcCall("getSchema");
        if (this.inputAvroSchema == null) {
            this.inputAvroSchema = this.getAvroSchema(location, job);
        }
        ASLog.details("avro input schema:" + this.inputAvroSchema);
        ResourceSchema pigSchema = AvroSchema2Pig.convert(this.inputAvroSchema);
        ASLog.details("pig input schema:" + pigSchema);
        return pigSchema;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    public AvroStorage() {
        ASLog.setDebugLevel(0);
        this.checkSchema = true;
    }

    public AvroStorage(String[] parts) throws IOException, ParseException {
        this.checkSchema = true;
        if (parts.length == 1 && parts[0].equalsIgnoreCase("no_schema_check")) {
            this.checkSchema = false;
        } else {
            Map<String, Object> map = parts.length > 1 ? this.parseStringList(parts) : this.parseJsonString(parts[0]);
            this.init(map);
        }
    }

    protected Map<String, Object> parseJsonString(String jsonString) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(jsonString);
        Set entries = obj.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equalsIgnoreCase("debug") || key.equalsIgnoreCase("index")) {
                int v = ((Long)value).intValue();
                obj.put((Object)key, (Object)v);
                continue;
            }
            if (!key.equalsIgnoreCase("schema") && !key.matches("field\\d+")) continue;
            obj.put((Object)key, (Object)value.toString().trim());
        }
        return obj;
    }

    protected Map<String, Object> parseStringList(String[] parts) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parts.length - 1; i += 2) {
            String name = parts[i].trim();
            String value = parts[i + 1].trim();
            if (name.equalsIgnoreCase("debug") || name.equalsIgnoreCase("index")) {
                map.put(name, Integer.parseInt(value));
                continue;
            }
            if (name.equalsIgnoreCase("data") || name.equalsIgnoreCase("same") || name.equalsIgnoreCase("schema") || name.matches("field\\d+")) {
                map.put(name, value);
                continue;
            }
            if (name.equalsIgnoreCase("nullable")) {
                map.put(name, Boolean.getBoolean(value));
                continue;
            }
            throw new IOException("Invalid parameter:" + name);
        }
        return map;
    }

    protected void init(Map<String, Object> inputs) throws IOException {
        ArrayList<Schema.Field> fields = null;
        if (inputs.containsKey("debug")) {
            ASLog.setDebugLevel((Integer)inputs.get("debug"));
        }
        AvroSchemaManager schemaManager = null;
        if (inputs.containsKey("data")) {
            Path path = new Path((String)inputs.get("data"));
            ASLog.details("data path=" + path.toUri().toString());
            FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
            Schema schema = this.getAvroSchema(path, fs);
            schemaManager = new AvroSchemaManager(schema);
        }
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            String name = entry.getKey().trim();
            Object value = entry.getValue();
            if (name.equalsIgnoreCase("index")) {
                this.storeFuncIndex = (Integer)value;
                continue;
            }
            if (name.equalsIgnoreCase("same")) {
                Path path = new Path(((String)value).trim());
                ASLog.details("data path=" + path.toUri().toString());
                FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
                this.outputAvroSchema = this.getAvroSchema(path, fs);
                continue;
            }
            if (name.equalsIgnoreCase("nullable")) {
                this.nullable = (Boolean)value;
                continue;
            }
            if (name.equalsIgnoreCase("schema")) {
                this.outputAvroSchema = Schema.parse((String)((String)value));
                continue;
            }
            if (name.matches("field\\d+")) {
                if (fields == null) {
                    fields = new ArrayList<Schema.Field>();
                }
                int index = Integer.parseInt(name.substring("field".length()));
                String content = ((String)value).trim();
                Schema.Field field = null;
                if (content.equalsIgnoreCase(NOTNULL)) {
                    field = ASCommons.createUDField(index, null);
                } else if (content.startsWith("def:")) {
                    if (schemaManager == null) {
                        throw new IOException("Please specify data parameter (using \"data\") before this one.");
                    }
                    String alias = content.substring("def:".length());
                    Schema s = schemaManager.getSchema(alias);
                    if (s == null) {
                        throw new IOException("Cannot find matching schema for alias:" + alias);
                    }
                    field = ASCommons.createUDField(index, s);
                    ASLog.details("Use pre-defined schema(" + alias + "): " + s + " for field " + index);
                } else {
                    Schema schema = null;
                    try {
                        schema = Schema.parse((String)content);
                    }
                    catch (RuntimeException e) {
                        schema = Schema.parse((String)("\"" + content + "\""));
                    }
                    field = ASCommons.createUDField(index, schema);
                }
                fields.add(field);
                continue;
            }
            if (name.equalsIgnoreCase("data") || name.equalsIgnoreCase("debug")) continue;
            throw new IOException("Invalid parameter:" + name);
        }
        if (fields != null && this.outputAvroSchema == null) {
            this.outputAvroSchema = ASCommons.createUDPartialRecordSchema();
            this.outputAvroSchema.setFields(fields);
        }
        if (this.outputAvroSchema != null && !this.nullable) {
            ASLog.warn("Invalid parameter--nullable cannot be false while output schema is not null. Will ignore nullable.\n\n");
            this.nullable = true;
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath((String)location, (Path)curDir);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        ASLog.details("output location=" + location);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        Map<String, String> schemaMap;
        ASLog.funcCall("Check schema");
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(ResourceSchema.class);
        String prevSchemaStr = property.getProperty(AVRO_OUTPUT_SCHEMA_PROPERTY);
        ASLog.details("Previously defined schemas=" + prevSchemaStr);
        String key = this.getSchemaKey();
        Map<String, String> map = schemaMap = prevSchemaStr != null ? this.parseSchemaMap(prevSchemaStr) : null;
        if (schemaMap != null && schemaMap.containsKey(key)) {
            ASLog.warn("Duplicate value for key-" + key + ". Will ignore the new schema.");
            return;
        }
        Schema schema = this.outputAvroSchema != null ? PigSchema2Avro.validateAndConvert(this.outputAvroSchema, s) : PigSchema2Avro.convert(s, this.nullable);
        ASLog.info("key=" + key + " outputSchema=" + schema);
        String schemaStr = schema.toString();
        String append = key + SCHEMA_KEYVALUE_DELIM + schemaStr;
        String newSchemaStr = schemaMap != null ? prevSchemaStr + SCHEMA_DELIM + append : append;
        property.setProperty(AVRO_OUTPUT_SCHEMA_PROPERTY, newSchemaStr);
        ASLog.details("New schemas=" + newSchemaStr);
    }

    private String getSchemaKey() {
        return Integer.toString(this.storeFuncIndex);
    }

    private Map<String, String> parseSchemaMap(String input) throws IOException {
        ASLog.details("Parse schema map from " + input);
        String[] entries = input.split(SCHEMA_DELIM);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entries) {
            ASLog.details("Entry = " + entry);
            if (entry.length() == 0) continue;
            String[] parts = entry.split(SCHEMA_KEYVALUE_DELIM);
            if (parts.length != 2) {
                throw new IOException("Expect 2 fields in " + entry);
            }
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    public OutputFormat getOutputFormat() throws IOException {
        Schema schema;
        ASLog.funcCall("getOutputFormat");
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(ResourceSchema.class);
        String allSchemaStr = property.getProperty(AVRO_OUTPUT_SCHEMA_PROPERTY);
        Map<String, String> map = allSchemaStr != null ? this.parseSchemaMap(allSchemaStr) : null;
        String key = this.getSchemaKey();
        Schema schema2 = schema = map == null || !map.containsKey(key) ? this.outputAvroSchema : Schema.parse((String)map.get(key));
        if (schema == null) {
            throw new IOException("Output schema is null!");
        }
        ASLog.details("Output schema=" + schema);
        return new PigAvroOutputFormat(schema);
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = (PigAvroRecordWriter)writer;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl((String)location, (Job)job);
    }

    public void putNext(Tuple t) throws IOException {
        try {
            this.writer.write(NullWritable.get(), (Object)t);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

