/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.ResourceSchema;
import org.apache.pig.piggybank.storage.avro.ASLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASCommons {
    public static Schema BooleanSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    public static Schema LongSchema = Schema.create((Schema.Type)Schema.Type.LONG);
    public static Schema FloatSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
    public static Schema DoubleSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
    public static Schema IntSchema = Schema.create((Schema.Type)Schema.Type.INT);
    public static Schema StringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
    public static Schema BytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
    public static Schema NullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final String NONAME = "NONAME";
    private static final String PIG_TUPLE_WRAPPER = "PIG_WRAPPER";
    public static PathFilter PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return !path.getName().startsWith("_") && !path.getName().startsWith(".");
        }
    };

    static String getDummyFieldName(int index) {
        return "NONAME_" + index;
    }

    public static Schema.Field createUDField(int index, Schema s) {
        return new Schema.Field(ASCommons.getDummyFieldName(index), s, null, null);
    }

    public static Schema createUDPartialRecordSchema() {
        return Schema.createRecord((String)NONAME, null, null, (boolean)false);
    }

    public static boolean isUDPartialRecordSchema(Schema s) {
        return s.getName().equals(NONAME);
    }

    public static Schema.Field getUDField(Schema s, int index) {
        return s.getField(ASCommons.getDummyFieldName(index));
    }

    public static void addInputPaths(String pathString, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path(pathString);
        FileStatus pathStatus = fs.getFileStatus(path);
        LinkedList<FileStatus> input = new LinkedList<FileStatus>();
        input.add(pathStatus);
        while (!input.isEmpty()) {
            FileStatus status = (FileStatus)input.remove(0);
            Path p = status.getPath();
            if (!status.isDir()) {
                ASLog.details("Add input path:" + p);
                FileInputFormat.addInputPath((Job)job, (Path)p);
                continue;
            }
            FileStatus[] ss = fs.listStatus(p, PATH_FILTER);
            if (ss.length <= 0) continue;
            if (ASCommons.noDir(ss)) {
                ASLog.details("Add input path:" + p);
                FileInputFormat.addInputPath((Job)job, (Path)p);
                continue;
            }
            input.addAll(Arrays.asList(ss));
        }
    }

    public static boolean noDir(FileStatus[] ss) throws IOException {
        for (FileStatus s : ss) {
            if (!s.isDir()) continue;
            return false;
        }
        return true;
    }

    public static Path getLast(String path, FileSystem fs) throws IOException {
        return ASCommons.getLast(new Path(path), fs);
    }

    public static Path getLast(Path path, FileSystem fs) throws IOException {
        Object[] statuses = fs.listStatus(path, PATH_FILTER);
        if (statuses.length == 0) {
            return path;
        }
        Arrays.sort(statuses);
        return statuses[statuses.length - 1].getPath();
    }

    public static Schema wrapAsUnion(Schema schema, boolean nullable) {
        if (nullable) {
            if (schema.getType().equals((Object)Schema.Type.UNION) && ASCommons.isAcceptableUnion(schema)) {
                return schema;
            }
            return Schema.createUnion(Arrays.asList(NullSchema, schema));
        }
        return schema;
    }

    public static boolean containRecursiveRecord(Schema s) {
        HashSet<String> set = new HashSet<String>();
        return ASCommons.containRecursiveRecord(s, set);
    }

    protected static boolean containRecursiveRecord(Schema s, Set<String> definedRecordNames) {
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            String name = s.getName();
            if (definedRecordNames.contains(name)) {
                return true;
            }
            definedRecordNames.add(s.getName());
            List fields = s.getFields();
            for (Schema.Field field : fields) {
                Schema fs = field.schema();
                if (!ASCommons.containRecursiveRecord(fs, definedRecordNames)) continue;
                return true;
            }
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.ARRAY)) {
            Schema fs = s.getElementType();
            return ASCommons.containRecursiveRecord(fs, definedRecordNames);
        }
        if (s.getType().equals((Object)Schema.Type.MAP)) {
            Schema vs = s.getValueType();
            return ASCommons.containRecursiveRecord(vs, definedRecordNames);
        }
        if (s.getType().equals((Object)Schema.Type.UNION)) {
            List types = s.getTypes();
            for (Schema type : types) {
                if (!ASCommons.containRecursiveRecord(type, definedRecordNames)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containGenericUnion(Schema s) {
        if (s.getType().equals((Object)Schema.Type.RECORD)) {
            List fields = s.getFields();
            for (Schema.Field field : fields) {
                Schema fs = field.schema();
                if (!ASCommons.containGenericUnion(fs)) continue;
                return true;
            }
            return false;
        }
        if (s.getType().equals((Object)Schema.Type.ARRAY)) {
            Schema fs = s.getElementType();
            return ASCommons.containGenericUnion(fs);
        }
        if (s.getType().equals((Object)Schema.Type.MAP)) {
            Schema vs = s.getValueType();
            return ASCommons.containGenericUnion(vs);
        }
        if (s.getType().equals((Object)Schema.Type.UNION)) {
            List types = s.getTypes();
            for (Schema type : types) {
                if (!ASCommons.containGenericUnion(type)) continue;
                return true;
            }
            return !ASCommons.isAcceptableUnion(s);
        }
        return false;
    }

    public static boolean isAcceptableUnion(Schema in) {
        if (!in.getType().equals((Object)Schema.Type.UNION)) {
            return false;
        }
        List types = in.getTypes();
        if (types.size() <= 1) {
            return true;
        }
        if (types.size() > 2) {
            return false;
        }
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)types.get(1)).getType().equals((Object)Schema.Type.NULL);
    }

    public static ResourceSchema.ResourceFieldSchema wrapAsTuple(ResourceSchema.ResourceFieldSchema subFieldSchema) throws IOException {
        ResourceSchema listSchema = new ResourceSchema();
        listSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{subFieldSchema});
        ResourceSchema.ResourceFieldSchema tupleWrapper = new ResourceSchema.ResourceFieldSchema();
        tupleWrapper.setType((byte)110);
        tupleWrapper.setName(PIG_TUPLE_WRAPPER);
        tupleWrapper.setSchema(listSchema);
        return tupleWrapper;
    }

    public static boolean isTupleWrapper(ResourceSchema.ResourceFieldSchema pigSchema) {
        return pigSchema.getType() == 110 && pigSchema.getName().equals(PIG_TUPLE_WRAPPER);
    }

    public static Schema getAcceptedType(Schema in) {
        if (!ASCommons.isAcceptableUnion(in)) {
            throw new RuntimeException("Cannot call this function on a unacceptable union");
        }
        List types = in.getTypes();
        switch (types.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Schema)types.get(0);
            }
            case 2: {
                return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
            }
        }
        return null;
    }
}

