/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import kafka.common.ErrorMapping$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001y4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\tA\u0001\u0004\u0003\u001d5+7o]1hKN+GoU3oI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u0010+A\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u00059a.\u001a;x_J\\\u0017B\u0001\u000b\u0012\u0005\u0011\u0019VM\u001c3\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t9\u0001\u0011)\u0019!C\u0001=\u0005AQ.Z:tC\u001e,7o\u0001\u0001\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\u000f5,7o]1hK&\u0011A%\t\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u00135,7o]1hKN\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,W#\u0001\u0016\u0011\u0005YY\u0013B\u0001\u0017\u0018\u0005\rIe\u000e\u001e\u0005\t]\u0001\u0011\t\u0011)A\u0005U\u0005QQM\u001d:pe\u000e{G-\u001a\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\r\u0011D'\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u00069=\u0002\ra\b\u0005\u0006Q=\u0002\rA\u000b\u0005\bo\u0001\u0001\r\u0011\"\u00039\u0003\u0011\u0019XM\u001c;\u0016\u0003e\u0002\"A\u0006\u001e\n\u0005m:\"\u0001\u0002'p]\u001eDq!\u0010\u0001A\u0002\u0013%a(\u0001\u0005tK:$x\fJ3r)\ty$\t\u0005\u0002\u0017\u0001&\u0011\u0011i\u0006\u0002\u0005+:LG\u000fC\u0004Dy\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006K!O\u0001\u0006g\u0016tG\u000f\t\u0005\b\u000f\u0002\u0001\r\u0011\"\u00039\u0003\u0011\u0019\u0018N_3\t\u000f%\u0003\u0001\u0019!C\u0005\u0015\u0006A1/\u001b>f?\u0012*\u0017\u000f\u0006\u0002@\u0017\"91\tSA\u0001\u0002\u0004I\u0004BB'\u0001A\u0003&\u0011(A\u0003tSj,\u0007\u0005C\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\r!,\u0017\rZ3s+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\f\u0003\rq\u0017n\\\u0005\u0003-N\u0013!BQ=uK\n+hMZ3s\u0011\u0019A\u0006\u0001)A\u0005#\u00069\u0001.Z1eKJ\u0004\u0003b\u0002.\u0001\u0001\u0004%\taW\u0001\tG>l\u0007\u000f\\3uKV\tA\f\u0005\u0002\u0017;&\u0011al\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\u0001\u0007\u00011A\u0005\u0002\u0005\fAbY8na2,G/Z0%KF$\"a\u00102\t\u000f\r{\u0016\u0011!a\u00019\"1A\r\u0001Q!\nq\u000b\u0011bY8na2,G/\u001a\u0011\t\u000bA\u0002A\u0011\u00014\u0015\u0005I:\u0007\"\u0002\u000ff\u0001\u0004y\u0002\"\u0002\u0019\u0001\t\u0003IG#\u0001\u001a\t\u000b-\u0004A\u0011\u00017\u0002\u000f]\u0014\u0018\u000e^3U_R\u0011!&\u001c\u0005\u0006]*\u0004\ra\\\u0001\bG\"\fgN\\3m!\t\u00018/D\u0001r\u0015\t\u00118+\u0001\u0005dQ\u0006tg.\u001a7t\u0013\t!\u0018O\u0001\u000bHCRDWM]5oO\nKH/Z\"iC:tW\r\u001c\u0005\u0006m\u0002!\t!K\u0001\tg\u0016tGmU5{K\"\u0012\u0001\u0001\u001f\t\u0003srl\u0011A\u001f\u0006\u0003w\u0012\tQ!\u001e;jYNL!! >\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class MessageSetSend
implements Send,
ScalaObject {
    private final MessageSet messages;
    private final int errorCode;
    private long sent;
    private long size;
    private final ByteBuffer header;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int writeCompletely(GatheringByteChannel channel) {
        return Send$class.writeCompletely(this, channel);
    }

    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MessageSetSend messageSetSend = this;
        synchronized (messageSetSend) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public MessageSet messages() {
        return this.messages;
    }

    public int errorCode() {
        return this.errorCode;
    }

    private long sent() {
        return this.sent;
    }

    private void sent_$eq(long l) {
        this.sent = l;
    }

    private long size() {
        return this.size;
    }

    private void size_$eq(long l) {
        this.size = l;
    }

    private ByteBuffer header() {
        return this.header;
    }

    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    public MessageSetSend(MessageSet messages) {
        this(messages, ErrorMapping$.MODULE$.NoError());
    }

    public MessageSetSend() {
        this(MessageSet$.MODULE$.Empty());
    }

    /*
     * WARNING - void declaration
     */
    public int writeTo(GatheringByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int written = 0;
        if (this.header().hasRemaining()) {
            written += channel.write(this.header());
        }
        if (!this.header().hasRemaining()) {
            long fileBytesSent = this.messages().writeTo(channel, this.sent(), this.size() - this.sent());
            written += (int)fileBytesSent;
            this.sent_$eq(this.sent() + fileBytesSent);
        }
        if (this.logger().isTraceEnabled() && channel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)channel;
            this.logger().trace((Object)new StringBuilder().append(this.sent()).append((Object)" bytes written to ").append((Object)socketChannel.socket().getRemoteSocketAddress()).append((Object)" expecting to send ").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)" bytes").toString());
        }
        if (this.sent() >= this.size()) {
            this.complete_$eq(true);
        }
        return (int)var2_2;
    }

    public int sendSize() {
        return (int)this.size() + this.header().capacity();
    }

    public MessageSetSend(MessageSet messages, int errorCode) {
        this.messages = messages;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.sent = 0L;
        this.size = messages.sizeInBytes();
        this.header = ByteBuffer.allocate(6);
        this.header().putInt((int)this.size() + 2);
        this.header().putShort((short)errorCode);
        this.header().rewind();
        this.complete = false;
    }
}

