/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.LogManager;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.network.SocketServer;
import kafka.network.SocketServerStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandlers;
import kafka.server.KafkaServer$;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Mx4jLoader$;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u000511m\u001c8gS\u001e,\u0012a\b\t\u0003A\u0005j\u0011AA\u0005\u0003E\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"AA\u0005\u0001B\u0001B\u0003%q$A\u0004d_:4\u0017n\u001a\u0011\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002!\u0001!)Q$\na\u0001?!91\u0006\u0001b\u0001\n\u0003a\u0013aE\"M\u000b\u0006sul\u0015%V)\u0012{uKT0G\u00132+U#A\u0017\u0011\u0005%q\u0013BA\u0018\u000b\u0005\u0019\u0019FO]5oO\"1\u0011\u0007\u0001Q\u0001\n5\nAc\u0011'F\u0003:{6\u000bS+U\t>;fj\u0018$J\u0019\u0016\u0003\u0003bB\u001a\u0001\u0001\u0004%I\u0001N\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o+\u0005)\u0004C\u0001\u001c>\u001b\u00059$B\u0001\u001d:\u0003\u0019\tGo\\7jG*\u0011!hO\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001f\r\u0003\u0011)H/\u001b7\n\u0005y:$!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004A\u0001\u0001\u0007I\u0011B!\u0002%%\u001c8\u000b[;ui&tw\rR8x]~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"aF\"\n\u0005\u0011C\"\u0001B+oSRDqAR \u0002\u0002\u0003\u0007Q'A\u0002yIEBa\u0001\u0013\u0001!B\u0013)\u0014aD5t'\",H\u000f^5oO\u0012{wO\u001c\u0011\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006i1\u000f[;uI><h\u000eT1uG\",\u0012\u0001\u0014\t\u0003\u001b:k\u0011!O\u0005\u0003\u001ff\u0012abQ8v]R$un\u001e8MCR\u001c\u0007\u000eC\u0004R\u0001\u0001\u0007I\u0011\u0002*\u0002#MDW\u000f\u001e3po:d\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002C'\"9a\tUA\u0001\u0002\u0004a\u0005BB+\u0001A\u0003&A*\u0001\btQV$Hm\\<o\u0019\u0006$8\r\u001b\u0011\t\u000f]\u0003!\u0019!C\u0005Y\u0005q1\u000f^1ug6\u0013U-\u00198OC6,\u0007BB-\u0001A\u0003%Q&A\bti\u0006$8/\u0014\"fC:t\u0015-\\3!\u0011\u001dY\u0006\u00011A\u0005\u0002q\u000bAb]8dW\u0016$8+\u001a:wKJ,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u0012\tqA\\3uo>\u00148.\u0003\u0002c?\na1k\\2lKR\u001cVM\u001d<fe\"9A\r\u0001a\u0001\n\u0003)\u0017\u0001E:pG.,GoU3sm\u0016\u0014x\fJ3r)\t\u0011e\rC\u0004GG\u0006\u0005\t\u0019A/\t\r!\u0004\u0001\u0015)\u0003^\u00035\u0019xnY6fiN+'O^3sA!9!\u000e\u0001b\u0001\n\u0003Y\u0017!C:dQ\u0016$W\u000f\\3s+\u0005a\u0007CA\tn\u0013\tq'C\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\t\rA\u0004\u0001\u0015!\u0003m\u0003)\u00198\r[3ek2,'\u000f\t\u0005\be\u0002\u0001\r\u0011\"\u0003t\u0003)awnZ'b]\u0006<WM]\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fB\u0001\u0004Y><\u0017BA=w\u0005)aunZ'b]\u0006<WM\u001d\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u00039awnZ'b]\u0006<WM]0%KF$\"AQ?\t\u000f\u0019S\u0018\u0011!a\u0001i\"1q\u0010\u0001Q!\nQ\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA!9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011aB:uCJ$X\u000f\u001d\u000b\u0002\u0005\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005\u0015\u0011\u0001C:ikR$wn\u001e8\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0006\u0005i\u0011m^1jiNCW\u000f\u001e3po:Dq!!\u0005\u0001\t\u0003\t\u0019\"A\u0007hKRdunZ'b]\u0006<WM\u001d\u000b\u0002i\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011\u0001C4fiN#\u0018\r^:\u0015\u0005\u0005m\u0001c\u00010\u0002\u001e%\u0019\u0011qD0\u0003#M{7m[3u'\u0016\u0014h/\u001a:Ti\u0006$8\u000f")
public class KafkaServer
implements Logging,
ScalaObject {
    private final KafkaConfig config;
    private final String CLEAN_SHUTDOWN_FILE;
    private AtomicBoolean isShuttingDown;
    private CountDownLatch shutdownLatch;
    private final String statsMBeanName;
    private SocketServer socketServer;
    private final KafkaScheduler scheduler;
    private LogManager logManager;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaServer kafkaServer = this;
        synchronized (kafkaServer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String CLEAN_SHUTDOWN_FILE() {
        return this.CLEAN_SHUTDOWN_FILE;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    private void isShuttingDown_$eq(AtomicBoolean atomicBoolean) {
        this.isShuttingDown = atomicBoolean;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch countDownLatch) {
        this.shutdownLatch = countDownLatch;
    }

    private String statsMBeanName() {
        return this.statsMBeanName;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer socketServer) {
        this.socketServer = socketServer;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private void logManager_$eq(LogManager logManager) {
        this.logManager = logManager;
    }

    public void startup() {
        Object object;
        this.info((Function0<String>)new $anonfun$startup$1(this));
        this.isShuttingDown_$eq(new AtomicBoolean(false));
        this.shutdownLatch_$eq(new CountDownLatch(1));
        boolean needRecovery = true;
        File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
        if (cleanShutDownFile.exists()) {
            needRecovery = false;
            object = BoxesRunTime.boxToBoolean((boolean)cleanShutDownFile.delete());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.logManager_$eq(new LogManager(this.config(), this.scheduler(), SystemTime$.MODULE$, 3600000L * (long)this.config().logRollHours(), 60000L * (long)this.config().logCleanupIntervalMinutes(), 3600000L * (long)this.config().logRetentionHours(), needRecovery));
        KafkaRequestHandlers handlers$1 = new KafkaRequestHandlers(this.logManager());
        this.socketServer_$eq(new SocketServer(this.config().port(), this.config().numThreads(), this.config().monitoringPeriodSecs(), (Function2<Short, Receive, Function1<Receive, Option<Send>>>)new $anonfun$startup$2(this, handlers$1), this.config().socketSendBuffer(), this.config().socketReceiveBuffer(), this.config().maxSocketRequestSize()));
        Utils$.MODULE$.registerMBean(this.socketServer().stats(), this.statsMBeanName());
        this.socketServer().startup();
        Mx4jLoader$.MODULE$.maybeLoad();
        this.logManager().startup();
        this.info((Function0<String>)new $anonfun$startup$3(this));
    }

    public void shutdown() {
        boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
        if (canShutdown) {
            this.info((Function0<String>)new $anonfun$shutdown$1(this));
            this.scheduler().shutdown();
            if (this.socketServer() != null) {
                this.socketServer().shutdown();
            }
            Utils$.MODULE$.unregisterMBean(this.statsMBeanName());
            if (this.logManager() != null) {
                this.logManager().close();
            }
            File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
            cleanShutDownFile.createNewFile();
            this.shutdownLatch().countDown();
            this.info((Function0<String>)new $anonfun$shutdown$2(this));
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public LogManager getLogManager() {
        return this.logManager();
    }

    public SocketServerStats getStats() {
        return this.socketServer().stats();
    }

    public KafkaServer(KafkaConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.CLEAN_SHUTDOWN_FILE = ".kafka_cleanshutdown";
        this.isShuttingDown = new AtomicBoolean(false);
        this.shutdownLatch = new CountDownLatch(1);
        this.statsMBeanName = "kafka:type=kafka.SocketServerStats";
        this.socketServer = null;
        this.scheduler = new KafkaScheduler(1, "kafka-logcleaner-", false);
        this.logManager = null;
    }
}

