/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import kafka.common.InvalidConfigException;
import kafka.message.CompressionCodec;
import kafka.producer.SyncProducerConfigShared;
import kafka.producer.SyncProducerConfigShared$class;
import kafka.producer.async.AsyncProducerConfigShared;
import kafka.producer.async.AsyncProducerConfigShared$class;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00194\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u000f!J|G-^2fe\u000e{gNZ5h\u0015\t\u0019A!\u0001\u0005qe>$WoY3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0006\u0001!qA\u0003\u0007\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\tQ!\u001e;jYNL!!\u0004\u0006\u0003\u0011i[5i\u001c8gS\u001e\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0002\u0002\u000b\u0005\u001c\u0018P\\2\n\u0005M\u0001\"!G!ts:\u001c\u0007K]8ek\u000e,'oQ8oM&<7\u000b[1sK\u0012\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u00031MKhn\u0019)s_\u0012,8-\u001a:D_:4\u0017nZ*iCJ,G\r\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\u000bA\u0014x\u000e]:\u0016\u0003\u0005\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001B\u000b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0007aJ|\u0007o\u001d\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\tqs\u0006\u0005\u0002\u0016\u0001!)qd\u000ba\u0001C!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0014A\u00032s_.,'\u000fT5tiV\t1\u0007\u0005\u00025o9\u0011\u0011$N\u0005\u0003mi\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011aG\u0007\u0005\u0007w\u0001\u0001\u000b\u0011B\u001a\u0002\u0017\t\u0014xn[3s\u0019&\u001cH\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003)qW/\u001c*fiJLWm]\u000b\u0002\u007fA\u0011\u0011\u0004Q\u0005\u0003\u0003j\u00111!\u00138u\u0011\u0019\u0019\u0005\u0001)A\u0005\u007f\u0005Ya.^7SKR\u0014\u0018.Z:!\u0011\u001d)\u0005A1A\u0005\u0002I\n\u0001\u0003]1si&$\u0018n\u001c8fe\u000ec\u0017m]:\t\r\u001d\u0003\u0001\u0015!\u00034\u0003E\u0001\u0018M\u001d;ji&|g.\u001a:DY\u0006\u001c8\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u00013\u00031\u0001(o\u001c3vG\u0016\u0014H+\u001f9f\u0011\u0019Y\u0005\u0001)A\u0005g\u0005i\u0001O]8ek\u000e,'\u000fV=qK\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002S\t\u00059Q.Z:tC\u001e,\u0017B\u0001+R\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\r\u0003\u0004W\u0001\u0001\u0006IaT\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003b\u0002-\u0001\u0005\u0004%\t!W\u0001\u0011G>l\u0007O]3tg\u0016$Gk\u001c9jGN,\u0012A\u0017\t\u00047z\u001bT\"\u0001/\u000b\u0005uS\u0012AC2pY2,7\r^5p]&\u0011q\f\u0018\u0002\u0004'\u0016\f\bBB1\u0001A\u0003%!,A\td_6\u0004(/Z:tK\u0012$v\u000e]5dg\u0002Bqa\u0019\u0001C\u0002\u0013\u0005a(A\u0007{WJ+\u0017\r\u001a*fiJLWm\u001d\u0005\u0007K\u0002\u0001\u000b\u0011B \u0002\u001di\\'+Z1e%\u0016$(/[3tA\u0001")
public class ProducerConfig
extends ZKConfig
implements AsyncProducerConfigShared,
SyncProducerConfigShared,
ScalaObject {
    private final Properties props;
    private final String brokerList;
    private final int numRetries;
    private final String partitionerClass;
    private final String producerType;
    private final CompressionCodec compressionCodec;
    private final Seq<String> compressedTopics;
    private final int zkReadRetries;
    private final int bufferSize;
    private final int connectTimeoutMs;
    private final int socketTimeoutMs;
    private final int reconnectInterval;
    private int reconnectTimeInterval;
    private final int maxMessageSize;
    private final int queueTime;
    private final int queueSize;
    private final int enqueueTimeoutMs;
    private final int batchSize;
    private final String serializerClass;
    private final String cbkHandler;
    private final Properties cbkHandlerProps;
    private final String eventHandler;
    private final Properties eventHandlerProps;

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Override
    public int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public int reconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public int reconnectTimeInterval() {
        return this.reconnectTimeInterval;
    }

    @Override
    public void reconnectTimeInterval_$eq(int n) {
        this.reconnectTimeInterval = n;
    }

    @Override
    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$bufferSize_$eq(int n) {
        this.bufferSize = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$connectTimeoutMs_$eq(int n) {
        this.connectTimeoutMs = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$socketTimeoutMs_$eq(int n) {
        this.socketTimeoutMs = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$reconnectInterval_$eq(int n) {
        this.reconnectInterval = n;
    }

    @Override
    public void kafka$producer$SyncProducerConfigShared$_setter_$maxMessageSize_$eq(int n) {
        this.maxMessageSize = n;
    }

    @Override
    public int queueTime() {
        return this.queueTime;
    }

    @Override
    public int queueSize() {
        return this.queueSize;
    }

    @Override
    public int enqueueTimeoutMs() {
        return this.enqueueTimeoutMs;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public String serializerClass() {
        return this.serializerClass;
    }

    @Override
    public String cbkHandler() {
        return this.cbkHandler;
    }

    @Override
    public Properties cbkHandlerProps() {
        return this.cbkHandlerProps;
    }

    @Override
    public String eventHandler() {
        return this.eventHandler;
    }

    @Override
    public Properties eventHandlerProps() {
        return this.eventHandlerProps;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$queueTime_$eq(int n) {
        this.queueTime = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$queueSize_$eq(int n) {
        this.queueSize = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$enqueueTimeoutMs_$eq(int n) {
        this.enqueueTimeoutMs = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$batchSize_$eq(int n) {
        this.batchSize = n;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$serializerClass_$eq(String string) {
        this.serializerClass = string;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$cbkHandler_$eq(String string) {
        this.cbkHandler = string;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$cbkHandlerProps_$eq(Properties properties) {
        this.cbkHandlerProps = properties;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$eventHandler_$eq(String string) {
        this.eventHandler = string;
    }

    @Override
    public void kafka$producer$async$AsyncProducerConfigShared$_setter_$eventHandlerProps_$eq(Properties properties) {
        this.eventHandlerProps = properties;
    }

    @Override
    public Properties props() {
        return this.props;
    }

    public String brokerList() {
        return this.brokerList;
    }

    public int numRetries() {
        return this.numRetries;
    }

    public String partitionerClass() {
        return this.partitionerClass;
    }

    public String producerType() {
        return this.producerType;
    }

    public CompressionCodec compressionCodec() {
        return this.compressionCodec;
    }

    public Seq<String> compressedTopics() {
        return this.compressedTopics;
    }

    public int zkReadRetries() {
        return this.zkReadRetries;
    }

    public ProducerConfig(Properties props) {
        this.props = props;
        super(props);
        AsyncProducerConfigShared$class.$init$(this);
        SyncProducerConfigShared$class.$init$(this);
        this.brokerList = Utils$.MODULE$.getString(props, "broker.list", null);
        if (Utils$.MODULE$.propertyExists(this.brokerList())) {
            if (Utils$.MODULE$.getString(props, "partitioner.class", null) != null) {
                throw new InvalidConfigException("partitioner.class cannot be used when broker.list is set");
            }
        }
        this.numRetries = Utils$.MODULE$.getInt(props, "num.retries", 0);
        if (Utils$.MODULE$.propertyExists(this.brokerList()) && Utils$.MODULE$.propertyExists(this.zkConnect())) {
            throw new InvalidConfigException("only one of broker.list and zk.connect can be specified");
        }
        if (Utils$.MODULE$.propertyExists(this.zkConnect()) || Utils$.MODULE$.propertyExists(this.brokerList())) {
            this.partitionerClass = Utils$.MODULE$.getString(props, "partitioner.class", "kafka.producer.DefaultPartitioner");
            this.producerType = Utils$.MODULE$.getString(props, "producer.type", "sync");
            this.compressionCodec = Utils$.MODULE$.getCompressionCodec(props, "compression.codec");
            this.compressedTopics = Utils$.MODULE$.getCSVList(Utils$.MODULE$.getString(props, "compressed.topics", null));
            this.zkReadRetries = Utils$.MODULE$.getInt(props, "zk.read.num.retries", 3);
            return;
        }
        throw new InvalidConfigException("At least one of zk.connect or broker.list must be specified");
    }
}

