/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFacade;
import kafka.message.CompressionFactory$;
import kafka.message.CompressionUtils$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.package$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CompressionUtils$
implements Logging,
ScalaObject {
    public static final CompressionUtils$ MODULE$;
    private CompressionCodec defaultCodec;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new CompressionUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        CompressionUtils$ compressionUtils$ = this;
        synchronized (compressionUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ CompressionCodec compress$default$2() {
        return DefaultCompressionCodec$.MODULE$;
    }

    private CompressionCodec defaultCodec() {
        return this.defaultCodec;
    }

    private void defaultCodec_$eq(CompressionCodec compressionCodec) {
        this.defaultCodec = compressionCodec;
    }

    public Message compress(Iterable<Message> messages$1, CompressionCodec compressionCodec) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.debug((Function0<String>)new anonfun.compress.1(messages$1));
        CompressionFacade cf = null;
        CompressionCodec compressionCodec2 = compressionCodec;
        DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
        cf = !(compressionCodec2 != null ? !compressionCodec2.equals(defaultCompressionCodec$) : defaultCompressionCodec$ != null) ? CompressionFactory$.MODULE$.apply(this.defaultCodec(), outputStream) : CompressionFactory$.MODULE$.apply(compressionCodec, outputStream);
        ByteBuffer messageByteBuffer$1 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages$1));
        messages$1.foreach((Function1)new anonfun.compress.2(messageByteBuffer$1));
        messageByteBuffer$1.rewind();
        try {
            cf.write(messageByteBuffer$1.array());
            Message oneCompressedMessage = new Message(outputStream.toByteArray(), compressionCodec);
            return oneCompressedMessage;
        }
        catch (IOException iOException) {
            this.error((Function0<String>)new anonfun.compress.3(), (Function0<Throwable>)new anonfun.compress.4(iOException));
            throw iOException;
        }
        finally {
            cf.close();
        }
    }

    public ByteBufferMessageSet decompress(Message message) {
        ByteBuffer outputBuffer;
        ByteArrayOutputStream outputStream$1 = new ByteArrayOutputStream();
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] intermediateBuffer$1 = new byte[1024];
        ObjectRef cf$1 = new ObjectRef(null);
        CompressionCodec compressionCodec = message.compressionCodec();
        DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
        cf$1.elem = !(compressionCodec != null ? !compressionCodec.equals(defaultCompressionCodec$) : defaultCompressionCodec$ != null) ? CompressionFactory$.MODULE$.apply(this.defaultCodec(), inputStream) : CompressionFactory$.MODULE$.apply(message.compressionCodec(), inputStream);
        try {
            package$.MODULE$.Stream().continually((Function0)new anonfun.decompress.1(intermediateBuffer$1, cf$1)).takeWhile((Function1)new anonfun.decompress.2()).foreach((Function1)new anonfun.decompress.3(outputStream$1, intermediateBuffer$1));
            outputBuffer = ByteBuffer.allocate(outputStream$1.size());
            outputBuffer.put(outputStream$1.toByteArray());
        }
        catch (IOException iOException) {
            this.error((Function0<String>)new anonfun.decompress.4(), (Function0<Throwable>)new anonfun.decompress.5(iOException));
            throw iOException;
        }
        finally {
            ((CompressionFacade)cf$1.elem).close();
        }
        outputBuffer.rewind();
        byte[] outputByteArray = outputStream$1.toByteArray();
        return new ByteBufferMessageSet(outputBuffer, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
    }

    private CompressionUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.defaultCodec = GZIPCompressionCodec$.MODULE$;
    }
}

