/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import kafka.api.FetchRequest;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.consumer.SimpleConsumer$;
import kafka.consumer.SimpleConsumerStats$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.network.Request;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\t!|7\u000f^\u000b\u0002?A\u0011\u0001e\t\b\u0003/\u0005J!A\t\r\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003EaA\u0001b\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0006Q>\u001cH\u000f\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005!\u0001o\u001c:u+\u0005Y\u0003CA\f-\u0013\ti\u0003DA\u0002J]RD\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0006a>\u0014H\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001U\u0005I1o\u001c+j[\u0016|W\u000f\u001e\u0005\tg\u0001\u0011\t\u0011)A\u0005W\u0005Q1o\u001c+j[\u0016|W\u000f\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002)\n!BY;gM\u0016\u00148+\u001b>f\u0011!9\u0004A!A!\u0002\u0013Y\u0013a\u00032vM\u001a,'oU5{K\u0002BQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtD#B\u001e>}}\u0002\u0005C\u0001\u001f\u0001\u001b\u0005\u0011\u0001\"B\u000f9\u0001\u0004y\u0002\"B\u00159\u0001\u0004Y\u0003\"B\u00199\u0001\u0004Y\u0003\"B\u001b9\u0001\u0004Y\u0003b\u0002\"\u0001\u0001\u0004%IaQ\u0001\bG\"\fgN\\3m+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003!\u0019\u0007.\u00198oK2\u001c(BA%\r\u0003\rq\u0017n\\\u0005\u0003\u0017\u001a\u0013QbU8dW\u0016$8\t[1o]\u0016d\u0007bB'\u0001\u0001\u0004%IAT\u0001\fG\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0002P%B\u0011q\u0003U\u0005\u0003#b\u0011A!\u00168ji\"91\u000bTA\u0001\u0002\u0004!\u0015a\u0001=%c!1Q\u000b\u0001Q!\n\u0011\u000b\u0001b\u00195b]:,G\u000e\t\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0003\u0011awnY6\u0016\u0003!AaA\u0017\u0001!\u0002\u0013A\u0011!\u00027pG.\u0004\u0003\"\u0002/\u0001\t\u0013i\u0016aB2p]:,7\r\u001e\u000b\u0002\t\")q\f\u0001C\u0005A\u0006)1\r\\8tKR\u0011q*\u0019\u0005\u0006\u0005z\u0003\r\u0001\u0012\u0005\u0006?\u0002!\ta\u0019\u000b\u0002\u001f\")Q\r\u0001C\u0001M\u0006)a-\u001a;dQR\u0011q-\u001c\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u0012\tq!\\3tg\u0006<W-\u0003\u0002mS\n!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDQA\u001c3A\u0002=\fqA]3rk\u0016\u001cH\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s\t\u0005\u0019\u0011\r]5\n\u0005Q\f(\u0001\u0004$fi\u000eD'+Z9vKN$\b\"\u0002<\u0001\t\u00039\u0018AC7vYRLg-\u001a;dQR\u0011\u0001p\u001f\t\u0003afL!A_9\u0003%5+H\u000e^5GKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0006yV\u0004\r!`\u0001\bM\u0016$8\r[3t!\r9bp\\\u0005\u0003\u007fb\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t\u0001cZ3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3\u0015\u0015\u0005\u001d\u00111CA\f\u00037\ty\u0002E\u0003\u0018\u0003\u0013\ti!C\u0002\u0002\fa\u0011Q!\u0011:sCf\u00042aFA\b\u0013\r\t\t\u0002\u0007\u0002\u0005\u0019>tw\rC\u0004\u0002\u0016\u0005\u0005\u0001\u0019A\u0010\u0002\u000bQ|\u0007/[2\t\u000f\u0005e\u0011\u0011\u0001a\u0001W\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\t\u0003;\t\t\u00011\u0001\u0002\u000e\u0005!A/[7f\u0011\u001d\t\t#!\u0001A\u0002-\nQ\"\\1y\u001dVlwJ\u001a4tKR\u001c\bbBA\u0013\u0001\u0011%\u0011qE\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000fF\u0002,\u0003SAqA\\A\u0012\u0001\u0004\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004B\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t)$a\f\u0003\u000fI+\u0017/^3ti\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0012aC4fiJ+7\u000f]8og\u0016$\"!!\u0010\u0011\r]\ty$a\u0011,\u0013\r\t\t\u0005\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u00055\u0012QI\u0005\u0005\u0003\u000f\nyCA\u0004SK\u000e,\u0017N^3\t\r\u0005-\u0003\u0001\"\u0003d\u0003M9W\r^(s\u001b\u0006\\WmQ8o]\u0016\u001cG/[8oQ\r\u0001\u0011q\n\t\u0004#\u0005E\u0013bAA*%\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class SimpleConsumer
implements Logging,
ScalaObject {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private SocketChannel channel;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private SocketChannel channel() {
        return this.channel;
    }

    private void channel_$eq(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    private Object lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    private SocketChannel connect() {
        void var2_2;
        this.close();
        InetSocketAddress address$1 = new InetSocketAddress(this.host(), this.port());
        SocketChannel channel$1 = SocketChannel.open();
        this.debug((Function0<String>)new $anonfun$connect$1(this, address$1));
        channel$1.configureBlocking(true);
        channel$1.socket().setReceiveBufferSize(this.bufferSize());
        channel$1.socket().setSoTimeout(this.soTimeout());
        channel$1.socket().setKeepAlive(true);
        channel$1.socket().setTcpNoDelay(true);
        channel$1.connect(address$1);
        this.trace((Function0<String>)new $anonfun$connect$2(this, channel$1));
        this.trace((Function0<String>)new $anonfun$connect$3(this, channel$1));
        return var2_2;
    }

    private void close(SocketChannel channel$2) {
        this.debug((Function0<String>)new $anonfun$close$3(this, channel$2));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$close$4(this), (Function0<Object>)new $anonfun$close$1(this, channel$2));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$close$5(this), (Function0<Object>)new $anonfun$close$2(this, channel$2));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            if (this.channel() != null) {
                this.close(this.channel());
            }
            this.channel_$eq(null);
            return;
        }
    }

    public ByteBufferMessageSet fetch(FetchRequest request$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$1, response$1);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$1.elem)._1()).buffer().limit());
            ByteBufferMessageSet byteBufferMessageSet = new ByteBufferMessageSet(((Receive)((Tuple2)response$1.elem)._1()).buffer(), request$1.offset(), ((Tuple2)response$1.elem)._2$mcI$sp());
            return byteBufferMessageSet;
        }
    }

    public MultiFetchResponse multifetch(Seq<FetchRequest> fetches$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$2 = new ObjectRef(null);
            this.liftedTree2$1(fetches$1, response$2);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$2.elem)._1()).buffer().limit());
            MultiFetchResponse multiFetchResponse = new MultiFetchResponse(((Receive)((Tuple2)response$2.elem)._1()).buffer(), fetches$1.length(), (long[])Predef$.MODULE$.refArrayOps((Object[])fetches$1.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))).map((Function1)new $anonfun$multifetch$1(this), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Long())));
            return multiFetchResponse;
        }
    }

    public long[] getOffsetsBefore(String topic$1, int partition$1, long time$1, int maxNumOffsets$1) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef response$3 = new ObjectRef(null);
            this.liftedTree3$1(topic$1, partition$1, time$1, maxNumOffsets$1, response$3);
            long[] lArray = OffsetRequest$.MODULE$.deserializeOffsetArray(((Receive)((Tuple2)response$3.elem)._1()).buffer());
            return lArray;
        }
    }

    private int sendRequest(Request request) {
        BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
        return send2.writeCompletely(this.channel());
    }

    private Tuple2<Receive, Integer> getResponse() {
        BoundedByteBufferReceive response = new BoundedByteBufferReceive();
        response.readCompletely(this.channel());
        short errorCode = response.buffer().getShort();
        return new Tuple2((Object)response, (Object)BoxesRunTime.boxToInteger((int)errorCode));
    }

    private void getOrMakeConnection() {
        if (this.channel() == null) {
            this.channel_$eq(this.connect());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(FetchRequest fetchRequest, ObjectRef objectRef) {
        try {
            this.sendRequest(fetchRequest);
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)new $anonfun$liftedTree1$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree1$1$2(this, iOException));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(fetchRequest);
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree2$1(Seq seq, ObjectRef objectRef) {
        try {
            this.sendRequest(new MultiFetchRequest((FetchRequest[])seq.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)new $anonfun$liftedTree2$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree2$1$2(this, iOException));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new MultiFetchRequest((FetchRequest[])seq.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree3$1(String string, int n, long l, int n2, ObjectRef objectRef) {
        try {
            this.sendRequest(new OffsetRequest(string, n, l, n2));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)new $anonfun$liftedTree3$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree3$1$2(this, iOException));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new OffsetRequest(string, n, l, n2));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        Logging$class.$init$(this);
        this.channel = null;
        this.lock = new Object();
    }
}

