/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.rat.api.Document;
import org.apache.rat.document.impl.AbstractMonolithicDocument;
import org.apache.rat.document.impl.DocumentImplUtils;

public class MonolithicFileDocument
extends AbstractMonolithicDocument {
    private final File file;

    public static Document newInstance(final URL url) {
        if ("file".equals(url.getProtocol())) {
            File f = new File(url.getFile());
            return new MonolithicFileDocument(f);
        }
        return new AbstractMonolithicDocument(url.toExternalForm()){

            public Reader reader() throws IOException {
                return new InputStreamReader(this.inputStream(), "UTF-8");
            }

            public InputStream inputStream() throws IOException {
                return url.openStream();
            }
        };
    }

    public MonolithicFileDocument(File file) {
        super(DocumentImplUtils.toName(file));
        this.file = file;
    }

    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }

    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

