/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class SimplePatternBasedLicense
implements IHeaderMatcher {
    private String licenseFamilyCategory;
    private String licenseFamilyName;
    private String notes;
    private String[] patterns;

    public SimplePatternBasedLicense() {
    }

    protected SimplePatternBasedLicense(MetaData.Datum pLicenseFamilyCategory, MetaData.Datum pLicenseFamilyName, String pNotes, String[] pPatterns) {
        if (!"http://org/apache/rat/meta-data#LicenseFamilyCategory".equals(pLicenseFamilyCategory.getName())) {
            throw new IllegalStateException("Expected http://org/apache/rat/meta-data#LicenseFamilyCategory, got " + pLicenseFamilyCategory.getName());
        }
        this.setLicenseFamilyCategory(pLicenseFamilyCategory.getValue());
        if (!"http://org/apache/rat/meta-data#LicenseFamilyName".equals(pLicenseFamilyName.getName())) {
            throw new IllegalStateException("Expected http://org/apache/rat/meta-data#LicenseFamilyName, got " + pLicenseFamilyName.getName());
        }
        this.setLicenseFamilyName(pLicenseFamilyName.getValue());
        this.setNotes(pNotes);
        this.setPatterns(pPatterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] pPatterns) {
        this.patterns = pPatterns;
    }

    public String getLicenseFamilyCategory() {
        return this.licenseFamilyCategory;
    }

    public void setLicenseFamilyCategory(String pDocumentCategory) {
        this.licenseFamilyCategory = pDocumentCategory;
    }

    public String getLicenseFamilyName() {
        return this.licenseFamilyName;
    }

    public void setLicenseFamilyName(String pLicenseFamilyCategory) {
        this.licenseFamilyName = pLicenseFamilyCategory;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String pNotes) {
        this.notes = pNotes;
    }

    protected void reportOnLicense(Document subject) throws RatHeaderAnalysisException {
        MetaData metaData = subject.getMetaData();
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderSample", this.notes));
        String licFamilyCategory = this.getLicenseFamilyCategory();
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderCategory", licFamilyCategory));
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", licFamilyCategory));
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#LicenseFamilyName", this.getLicenseFamilyName()));
    }

    protected boolean matches(String pLine) {
        String[] pttrns;
        if (pLine != null && (pttrns = this.getPatterns()) != null) {
            for (int i = 0; i < pttrns.length; ++i) {
                if (pLine.indexOf(pttrns[i], 0) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void reset() {
    }

    public boolean match(Document pSubject, String pLine) throws RatHeaderAnalysisException {
        boolean result = this.matches(pLine);
        if (result) {
            this.reportOnLicense(pSubject);
        }
        return result;
    }
}

