/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import java.util.regex.Pattern;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.BaseLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class OASISLicense
extends BaseLicense
implements IHeaderMatcher {
    private static final String COPYRIGHT_PATTERN_DEFN = ".*Copyright.*OASIS Open.*";
    private static final String CLAUSE_DEFN = ".*thisdocumentandtranslationsofitmaybecopiedandfurnishedtoothersandderivativeworksthatcommentonorotherwiseexplainitorassistinitsimplementationmaybepreparedcopiedpublishedanddistributed.*";
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile(".*Copyright.*OASIS Open.*");
    private static final Pattern CLAUSE_PATTERN = Pattern.compile(".*thisdocumentandtranslationsofitmaybecopiedandfurnishedtoothersandderivativeworksthatcommentonorotherwiseexplainitorassistinitsimplementationmaybepreparedcopiedpublishedanddistributed.*");
    boolean copyrightMatch = false;
    final StringBuffer buffer = new StringBuffer();

    public OASISLicense() {
        super(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_OASIS, MetaData.RAT_LICENSE_FAMILY_NAME_DATUM_OASIS_OPEN_LICENSE, "No modifications allowed");
    }

    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        boolean result = false;
        if (this.copyrightMatch) {
            line = line.toLowerCase();
            this.buffer.append(line);
            this.prune(this.buffer);
            boolean clauseMatch = CLAUSE_PATTERN.matcher(this.buffer).matches();
            if (clauseMatch) {
                result = true;
                this.reportOnLicense(subject);
            }
        } else {
            this.copyrightMatch = COPYRIGHT_PATTERN.matcher(line).matches();
        }
        return result;
    }

    private void prune(StringBuffer buffer) {
        int length;
        int i = length = buffer.length();
        while (i > 0) {
            char at;
            if ((at = buffer.charAt(--i)) >= 'a' && at <= 'z') continue;
            buffer.deleteCharAt(i);
        }
    }

    public void reset() {
        this.copyrightMatch = false;
        this.buffer.delete(0, this.buffer.length());
    }
}

