/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConnector;
import kafka.perf.ConsumerPerformance;
import kafka.perf.ConsumerPerformance$;
import kafka.serializer.Decoder;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ConsumerPerformance$
implements ScalaObject {
    public static final ConsumerPerformance$ MODULE$;
    private final Logger logger;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config$1 = new ConsumerPerformance.ConsumerPerfConfig(args);
        this.logger().info((Object)"Starting consumer...");
        ObjectRef totalMessagesRead$1 = new ObjectRef((Object)new AtomicLong(0L));
        ObjectRef totalBytesRead$1 = new ObjectRef((Object)new AtomicLong(0L));
        if (!config$1.hideHeader()) {
            if (config$1.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        Utils$.MODULE$.tryCleanupZookeeper(config$1.consumerConfig().zkConnect(), config$1.consumerConfig().groupId());
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(config$1.consumerConfig());
        Map topicMessageStreams = consumerConnector.createMessageStreams(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)config$1.topic()).$minus$greater((Object)BoxesRunTime.boxToInteger((int)config$1.numThreads()))})), (Decoder)consumerConnector.createMessageStreams$default$2());
        ObjectRef threadList$1 = new ObjectRef((Object)Nil$.MODULE$);
        topicMessageStreams.foreach((Function1)new anonfun.main.1(config$1, totalMessagesRead$1, totalBytesRead$1, threadList$1));
        this.logger().info((Object)"Sleeping for 1000 seconds.");
        Thread.sleep(1000L);
        this.logger().info((Object)"starting threads");
        long startMs = System.currentTimeMillis();
        ((List)threadList$1.elem).foreach((Function1)new anonfun.main.2());
        ((List)threadList$1.elem).foreach((Function1)new anonfun.main.3());
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs - (long)config$1.consumerConfig().consumerTimeoutMs()) / 1000.0;
        if (!config$1.showDetailedStats()) {
            double totalMBRead = (double)((AtomicLong)totalBytesRead$1.elem).get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config$1.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config$1.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config$1.consumerConfig().fetchSize()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsedSecs)), BoxesRunTime.boxToLong((long)((AtomicLong)totalMessagesRead$1.elem).get()), BoxesRunTime.boxToDouble((double)((double)((AtomicLong)totalMessagesRead$1.elem).get() / elapsedSecs))})));
        }
        System.exit(0);
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

