/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.hiverc;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.HiveColumnarLoader;
import org.apache.pig.piggybank.storage.hiverc.HiveRCRecordReader;
import org.apache.pig.piggybank.storage.partition.PathPartitionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiveRCInputFormat
extends FileInputFormat<LongWritable, BytesRefArrayWritable> {
    transient PathPartitionHelper partitionHelper = new PathPartitionHelper();
    String signature = "";

    public HiveRCInputFormat() {
        this(null);
    }

    public HiveRCInputFormat(String signature) {
        this.signature = signature;
        Properties properties = UDFContext.getUDFContext().getUDFProperties(HiveColumnarLoader.class, new String[]{signature});
        String partitionExpression = properties.getProperty(PathPartitionHelper.PARITITION_FILTER_EXPRESSION);
        String dateRange = properties.getProperty(HiveColumnarLoader.DATE_RANGE);
        if (partitionExpression == null && dateRange != null) {
            partitionExpression = this.buildFilterExpressionFromDatePartition(dateRange);
            properties.setProperty(PathPartitionHelper.PARITITION_FILTER_EXPRESSION, partitionExpression);
        }
    }

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        List files = this.partitionHelper.listStatus(jobContext, HiveColumnarLoader.class, this.signature);
        if (files == null) {
            files = super.listStatus(jobContext);
        }
        return files;
    }

    private String buildFilterExpressionFromDatePartition(String dateRange) {
        Properties properties = UDFContext.getUDFContext().getUDFProperties(HiveColumnarLoader.class, new String[]{this.signature});
        String partitionColumnStr = properties.getProperty(PathPartitionHelper.PARTITION_COLUMNS);
        boolean isYearMonthDayFormat = false;
        String key = null;
        if (partitionColumnStr.contains("daydate")) {
            key = "daydate";
        } else if (partitionColumnStr.contains("date")) {
            key = "date";
        } else if (partitionColumnStr.contains("year") && partitionColumnStr.contains("month") && partitionColumnStr.contains("day")) {
            isYearMonthDayFormat = true;
        } else {
            throw new RuntimeException("Not date partitions where found for partitions: " + partitionColumnStr);
        }
        String[] split = dateRange.split(":");
        if (split.length != 2) {
            throw new RuntimeException("The date range must have format yyyy-MM-dd:yyyy-MM-dd");
        }
        String partitionExpression = null;
        if (isYearMonthDayFormat) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date1 = HiveRCInputFormat.parseDate(dateFormat, split[0]);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date1);
            partitionExpression = "(year >= '" + cal.get(1) + "' and month >= '" + HiveRCInputFormat.formatNumber(cal.get(2) + 1) + "' and day >= '" + HiveRCInputFormat.formatNumber(cal.get(5)) + "')";
            Date date2 = HiveRCInputFormat.parseDate(dateFormat, split[1]);
            cal.setTime(date2);
            partitionExpression = partitionExpression + " and (year <= '" + cal.get(1) + "' and month <= '" + HiveRCInputFormat.formatNumber(cal.get(2) + 1) + "' and day <= '" + HiveRCInputFormat.formatNumber(cal.get(5)) + "')";
        } else {
            partitionExpression = key + " >= '" + split[0] + "' and " + key + " <= '" + split[1] + "'";
        }
        return partitionExpression;
    }

    private static final String formatNumber(int numb) {
        if (numb < 10) {
            return "0" + numb;
        }
        return "" + numb;
    }

    public RecordReader<LongWritable, BytesRefArrayWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws IOException, InterruptedException {
        HiveRCRecordReader reader = new HiveRCRecordReader();
        return reader;
    }

    private static final Date parseDate(DateFormat dateFormat, String dateString) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            RuntimeException rt = new RuntimeException(e);
            rt.setStackTrace(e.getStackTrace());
            throw rt;
        }
    }

    protected long getFormatMinSplitSize() {
        return 2000L;
    }
}

