/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.avro.ASFsInput;
import org.apache.pig.piggybank.storage.avro.ASLog;
import org.apache.pig.piggybank.storage.avro.PigAvroDatumReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigAvroRecordReader
extends RecordReader<NullWritable, Writable> {
    private ASFsInput in;
    private DataFileReader<Object> reader;
    private long start;
    private long end;
    private Schema schema = null;

    public PigAvroRecordReader(TaskAttemptContext context, FileSplit split, Schema s) throws IOException {
        this.in = new ASFsInput(split.getPath(), context);
        if (s == null) {
            throw new IOException("Need to provide input avro schema");
        }
        this.schema = s;
        this.reader = new DataFileReader((SeekableInput)this.in, (DatumReader)new PigAvroDatumReader(this.schema));
        this.reader.sync(split.getStart());
        this.start = this.in.tell();
        this.end = split.getStart() + split.getLength();
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public Writable getCurrentValue() throws IOException, InterruptedException {
        Object obj = this.reader.next();
        if (obj instanceof Tuple) {
            ASLog.details("Class =" + obj.getClass());
            return (Tuple)obj;
        }
        ASLog.details("Wrap calss " + obj.getClass() + " as a tuple.");
        return this.wrapAsTuple(obj);
    }

    protected Tuple wrapAsTuple(Object in) throws IOException {
        Tuple tuple = TupleFactory.getInstance().newTuple();
        tuple.append(in);
        return tuple;
    }

    public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.reader.hasNext() && !this.reader.pastSync(this.end);
    }
}

