/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.Expression;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;
import org.apache.pig.backend.hadoop.datastorage.HDirectory;
import org.apache.pig.backend.hadoop.datastorage.HFile;
import org.apache.pig.impl.io.FileLocalizer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMetadata
implements LoadMetadata,
StoreMetadata {
    private static final Log log = LogFactory.getLog(JsonMetadata.class);
    private String schemaFileName = ".pig_schema";
    private String headerFileName = ".pig_header";
    private String statFileName = ".pig_stats";
    private boolean printHeaders = true;
    private byte fieldDel;
    private byte recordDel;

    protected Set<ElementDescriptor> findMetaFile(String path, String prefix, Configuration conf) throws IOException {
        HDataStorage storage = new HDataStorage(ConfigurationUtil.toProperties((Configuration)conf));
        String fullPath = FileLocalizer.fullPath((String)path, (DataStorage)storage);
        HashSet<ElementDescriptor> metaFileSet = new HashSet<ElementDescriptor>();
        if (storage.isContainer(fullPath)) {
            ElementDescriptor metaFilePath = storage.asElement(fullPath, prefix);
            if (metaFilePath.exists()) {
                metaFileSet.add(metaFilePath);
            }
        } else {
            ElementDescriptor[] descriptors;
            for (ElementDescriptor descriptor : descriptors = storage.asCollection(path)) {
                ElementDescriptor metaFilePath;
                String fileName = null;
                String parentName = null;
                HDirectory parentContainer = null;
                if (descriptor instanceof HFile) {
                    Path descriptorPath = ((HFile)descriptor).getPath();
                    fileName = descriptorPath.getName();
                    Path parent = descriptorPath.getParent();
                    parentName = parent.toString();
                    parentContainer = new HDirectory(storage, parent);
                }
                if ((metaFilePath = storage.asElement(parentName, prefix + "." + fileName)).exists()) {
                    metaFileSet.add(metaFilePath);
                    continue;
                }
                metaFilePath = storage.asElement((ContainerDescriptor)parentContainer, prefix);
                if (!metaFilePath.exists()) continue;
                metaFileSet.add(metaFilePath);
            }
        }
        return metaFileSet;
    }

    public String[] getPartitionKeys(String location, Job job) {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        Set<ElementDescriptor> schemaFileSet = null;
        try {
            schemaFileSet = this.findMetaFile(location, this.schemaFileName, conf);
        }
        catch (IOException e) {
            log.warn((Object)("Could not find schema file for " + location));
            return null;
        }
        ElementDescriptor schemaFile = null;
        if (schemaFileSet.isEmpty()) {
            log.warn((Object)("Could not find schema file for " + location));
            return null;
        }
        schemaFile = schemaFileSet.iterator().next();
        log.info((Object)("Found schema file: " + schemaFile.toString()));
        ResourceSchema resourceSchema = null;
        try {
            resourceSchema = (ResourceSchema)new ObjectMapper().readValue(schemaFile.open(), ResourceSchema.class);
        }
        catch (JsonParseException e) {
            log.warn((Object)("Unable to load Resource Schema for " + location));
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            log.warn((Object)("Unable to load Resource Schema for " + location));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load Resource Schema for " + location));
            e.printStackTrace();
        }
        return resourceSchema;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        Set<ElementDescriptor> statFileSet = null;
        try {
            statFileSet = this.findMetaFile(location, this.statFileName, conf);
        }
        catch (IOException e) {
            log.warn((Object)("could not fine stat file for " + location));
            return null;
        }
        ElementDescriptor statFile = null;
        if (statFileSet.isEmpty()) {
            log.warn((Object)("Could not find stat file for " + location));
            return null;
        }
        statFile = statFileSet.iterator().next();
        log.info((Object)("Found stat file " + statFile.toString()));
        ResourceStatistics resourceStats = null;
        try {
            resourceStats = (ResourceStatistics)new ObjectMapper().readValue(statFile.open(), ResourceStatistics.class);
        }
        catch (JsonParseException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load Resource Statistics for " + location));
            e.printStackTrace();
        }
        return resourceStats;
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        HDataStorage storage = new HDataStorage(ConfigurationUtil.toProperties((Configuration)conf));
        ElementDescriptor statFilePath = storage.asElement(location, this.statFileName);
        if (!statFilePath.exists() && stats != null) {
            try {
                new ObjectMapper().writeValue(statFilePath.create(), (Object)stats);
            }
            catch (JsonGenerationException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        ElementDescriptor headerFilePath;
        Configuration conf = job.getConfiguration();
        HDataStorage storage = new HDataStorage(ConfigurationUtil.toProperties((Configuration)conf));
        ElementDescriptor schemaFilePath = storage.asElement(location, this.schemaFileName);
        if (!schemaFilePath.exists() && schema != null) {
            try {
                new ObjectMapper().writeValue(schemaFilePath.create(), (Object)schema);
            }
            catch (JsonGenerationException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                log.warn((Object)("Unable to write Resource Statistics for " + location));
                e.printStackTrace();
            }
        }
        if (this.printHeaders && !(headerFilePath = storage.asElement(location, this.headerFileName)).exists()) {
            OutputStream os = headerFilePath.create();
            try {
                String[] names = schema.fieldNames();
                for (int i = 0; i < names.length; ++i) {
                    os.write(names[i].getBytes("UTF-8"));
                    if (i < names.length - 1) {
                        os.write(this.fieldDel);
                        continue;
                    }
                    os.write(this.recordDel);
                }
            }
            finally {
                os.close();
            }
        }
    }

    public void setFieldDel(byte fieldDel) {
        this.fieldDel = fieldDel;
    }

    public void setRecordDel(byte recordDel) {
        this.recordDel = recordDel;
    }
}

