/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.math;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.piggybank.evaluation.math.DoubleGetExponent;
import org.apache.pig.piggybank.evaluation.math.FloatGetExponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class getExponent
extends EvalFunc<Integer> {
    public Integer exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        try {
            Double d = DataType.toDouble((Object)input.get(0));
            return Math.getExponent(d);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Failed to process input; error - " + nfe.getMessage());
            return null;
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input row ", e);
        }
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 10));
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 50))));
        funcList.add(new FuncSpec(DoubleGetExponent.class.getName(), new Schema(new Schema.FieldSchema(null, 25))));
        funcList.add(new FuncSpec(FloatGetExponent.class.getName(), new Schema(new Schema.FieldSchema(null, 20))));
        return funcList;
    }
}

