/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.datetime.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISOMonthsBetween
extends EvalFunc<Long> {
    public Long exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            return null;
        }
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        DateTime startDate = new DateTime((Object)input.get(0).toString());
        DateTime endDate = new DateTime((Object)input.get(1).toString());
        Months m = Months.monthsBetween((ReadableInstant)endDate, (ReadableInstant)startDate);
        long months = m.getMonths();
        return months;
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 15));
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), s));
        return funcList;
    }
}

