/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.datetime;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffDate
extends EvalFunc<Integer> {
    static DateFormat df = new SimpleDateFormat("yyyyMMdd");

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 10));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            String msg = "DiffDate : Only 2 parameters are allowed.";
            throw new IOException(msg);
        }
        String strDate1 = (String)input.get(0);
        String strDate2 = (String)input.get(1);
        if (input.get(0) == null || input.get(1) == null) {
            return null;
        }
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = df.parse(strDate1);
            date2 = df.parse(strDate2);
        }
        catch (ParseException e) {
            String msg = "DiffDate : Parameters have to be string in 'yyyymmdd' format.";
            this.warn(msg, (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        return (int)((date1.getTime() - date2.getTime()) / 86400000L);
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), s));
        return funcList;
    }
}

